<?php
require_once 'config/db.php';

// Get featured menu items
$conn = getDBConnection();
$featured_items = [];
$result = $conn->query("SELECT m.*, c.name as category_name FROM menu_items m JOIN categories c ON m.category_id = c.id WHERE m.featured = 1 AND m.active = 1 LIMIT 6");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $featured_items[] = $row;
    }
}

// Get approved reviews
$reviews = [];
$result = $conn->query("SELECT * FROM reviews WHERE status = 'approved' ORDER BY created_at DESC LIMIT 6");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $reviews[] = $row;
    }
}

// Get site settings
$settings = [];
$result = $conn->query("SELECT * FROM site_settings");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

$conn->close();

$whatsapp_number = $settings['whatsapp_number'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FRUITOLA - Daily Fresh Dose | Premium Fruit Shop</title>
    <meta name="description" content="FRUITOLA - Your daily fresh dose of fruits, smoothies, and healthy snacks. No sugar, no preservatives, only real fruits.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <span class="logo-text">FRUITOLA</span>
            </a>
            <ul class="nav-links" id="navLinks">
                <li><a href="index.php" class="active">Home</a></li>
                <li><a href="menu.php">Menu</a></li>
                <li><a href="reviews.php">Reviews</a></li>
                <li><a href="contact.php">Contact</a></li>
                <li><a href="roadmap.php">Roadmap</a></li>
            </ul>
            <div class="mobile-menu-btn" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-bg-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
        </div>
        
        <div class="hero-container">
            <div class="hero-content">
                <div class="hero-badge">
                    <span class="pulse"></span>
                    Fresh & Healthy Daily
                </div>
                <h1 class="hero-title">
                    Your <span class="gradient-text">Daily Fresh Dose</span> of Nature's Goodness
                </h1>
                <p class="hero-subtitle">
                    Premium fruit bowls, smoothies & healthy snacks made with 100% real fruits
                </p>
                <div class="hero-highlights">
                    <div class="highlight-item">
                        <i class="fas fa-check-circle"></i>
                        <span>No Sugar Added</span>
                    </div>
                    <div class="highlight-item">
                        <i class="fas fa-check-circle"></i>
                        <span>No Preservatives</span>
                    </div>
                    <div class="highlight-item">
                        <i class="fas fa-check-circle"></i>
                        <span>100% Real Fruits</span>
                    </div>
                </div>
                <div class="hero-buttons">
                    <a href="menu.php" class="btn btn-primary">
                        <i class="fas fa-utensils"></i>
                        View Menu
                    </a>
                    <?php if ($whatsapp_number): ?>
                    <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>" class="btn btn-whatsapp" target="_blank">
                        <i class="fab fa-whatsapp"></i>
                        Order on WhatsApp
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="hero-visual">
                <div class="fruit-card fruit-card-1">
                    <img src="https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400" alt="Fruit Salad">
                    <div class="fruit-card-content">
                        <div class="fruit-card-title">Tropical Bowl</div>
                        <div class="fruit-card-price">₹149</div>
                    </div>
                </div>
                <div class="fruit-card fruit-card-2">
                    <img src="https://images.unsplash.com/photo-1553530979-7ee52a2670c4?w=400" alt="Smoothie">
                    <div class="fruit-card-content">
                        <div class="fruit-card-title">Berry Blast</div>
                        <div class="fruit-card-price">₹129</div>
                    </div>
                </div>
                <div class="fruit-card fruit-card-3">
                    <img src="https://images.unsplash.com/photo-1511690656952-34342bb7c2f2?w=400" alt="Oats Bowl">
                    <div class="fruit-card-content">
                        <div class="fruit-card-title">Oats Paradise</div>
                        <div class="fruit-card-price">₹179</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Menu Section -->
    <section class="section featured-section">
        <div class="section-header">
            <h2 class="section-title">
                Our <span class="highlight">Featured</span> Items
            </h2>
            <p class="section-subtitle">
                Handpicked favorites that our customers love the most
            </p>
        </div>
        
        <div class="menu-slider">
            <?php if (!empty($featured_items)): ?>
                <?php foreach ($featured_items as $item): ?>
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="<?php echo $item['image'] ? 'assets/uploads/' . $item['image'] : 'https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400'; ?>" alt="<?php echo htmlspecialchars($item['name']); ?>">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category"><?php echo htmlspecialchars($item['category_name']); ?></span>
                        <h3 class="menu-card-title"><?php echo htmlspecialchars($item['name']); ?></h3>
                        <p class="menu-card-description"><?php echo htmlspecialchars(substr($item['description'], 0, 80)) . '...'; ?></p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹<?php echo number_format($item['price'], 2); ?></span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order <?php echo urlencode($item['name']); ?>" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- Default featured items if none in database -->
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400" alt="Tropical Fruit Bowl">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Fruit Salads</span>
                        <h3 class="menu-card-title">Tropical Paradise Bowl</h3>
                        <p class="menu-card-description">Fresh mango, pineapple, kiwi, and berries with honey drizzle</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹149</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Tropical Paradise Bowl" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1553530979-7ee52a2670c4?w=400" alt="Berry Smoothie">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Smoothies</span>
                        <h3 class="menu-card-title">Berry Blast Smoothie</h3>
                        <p class="menu-card-description">Strawberries, blueberries, raspberries with yogurt blend</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹129</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Berry Blast Smoothie" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1511690656952-34342bb7c2f2?w=400" alt="Oats Bowl">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Oats Bowls</span>
                        <h3 class="menu-card-title">Overnight Oats Delight</h3>
                        <p class="menu-card-description">Rolled oats soaked in almond milk with fresh fruits</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹179</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Overnight Oats Delight" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1543573852-1a71a6ce19bc?w=400" alt="Green Smoothie">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Smoothies</span>
                        <h3 class="menu-card-title">Green Detox Smoothie</h3>
                        <p class="menu-card-description">Spinach, kale, apple, and ginger for a healthy boost</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹139</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Green Detox Smoothie" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Reviews Section -->
    <section class="section reviews-section">
        <div class="section-header">
            <h2 class="section-title">
                What Our <span class="highlight">Customers</span> Say
            </h2>
            <p class="section-subtitle">
                Real reviews from real fruit lovers
            </p>
        </div>
        
        <div class="reviews-grid">
            <?php if (!empty($reviews)): ?>
                <?php foreach ($reviews as $review): ?>
                <div class="review-card">
                    <div class="review-header">
                        <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($review['customer_name']); ?>&background=f39c12&color=fff" alt="<?php echo htmlspecialchars($review['customer_name']); ?>" class="review-avatar">
                        <div class="review-info">
                            <h4><?php echo htmlspecialchars($review['customer_name']); ?></h4>
                            <div class="review-stars">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <i class="fas fa-star<?php echo $i <= $review['rating'] ? '' : '-o'; ?>"></i>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                    <p class="review-text">"<?php echo htmlspecialchars($review['review_text']); ?>"</p>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- Default reviews -->
                <div class="review-card">
                    <div class="review-header">
                        <img src="https://ui-avatars.com/api/?name=Priya+S&background=f39c12&color=fff" alt="Priya S" class="review-avatar">
                        <div class="review-info">
                            <h4>Priya Sharma</h4>
                            <div class="review-stars">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                    </div>
                    <p class="review-text">"Absolutely love FRUITOLA! Their fruit bowls are so fresh and delicious. The Tropical Paradise is my favorite. Highly recommend!"</p>
                </div>
                
                <div class="review-card">
                    <div class="review-header">
                        <img src="https://ui-avatars.com/api/?name=Rahul+M&background=e74c3c&color=fff" alt="Rahul M" class="review-avatar">
                        <div class="review-info">
                            <h4>Rahul Mehta</h4>
                            <div class="review-stars">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                    </div>
                    <p class="review-text">"Best smoothies in town! I order every morning before work. The Green Detox keeps me energized throughout the day."</p>
                </div>
                
                <div class="review-card">
                    <div class="review-header">
                        <img src="https://ui-avatars.com/api/?name=Ananya+K&background=27ae60&color=fff" alt="Ananya K" class="review-avatar">
                        <div class="review-info">
                            <h4>Ananya Kumar</h4>
                            <div class="review-stars">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star-half-o"></i>
                            </div>
                        </div>
                    </div>
                    <p class="review-text">"Finally a place that serves healthy food without compromising on taste. Their overnight oats are amazing!"</p>
                </div>
            <?php endif; ?>
        </div>
        
        <div style="text-align: center; margin-top: 40px;">
            <a href="reviews.php" class="btn btn-secondary">
                <i class="fas fa-pen"></i> Write a Review
            </a>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="cta-content">
            <h2 class="cta-title">Ready to Taste the Freshness?</h2>
            <p class="cta-text">Order now and get your daily dose of healthy, delicious fruits delivered to your doorstep</p>
            <div class="cta-buttons">
                <a href="menu.php" class="btn btn-white">
                    <i class="fas fa-utensils"></i> Browse Menu
                </a>
                <?php if ($whatsapp_number): ?>
                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>" class="btn btn-outline-white" target="_blank">
                    <i class="fab fa-whatsapp"></i> Order Now
                </a>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <div class="footer-brand">
                <h2 class="logo-text">FRUITOLA</h2>
                <p>Your daily fresh dose of nature's goodness. We serve premium fruit bowls, smoothies, and healthy snacks made with 100% real fruits.</p>
                <div class="footer-social">
                    <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Quick Links</h3>
                <ul class="footer-links">
                    <li><a href="index.php">Home</a></li>
                    <li><a href="menu.php">Our Menu</a></li>
                    <li><a href="reviews.php">Reviews</a></li>
                    <li><a href="contact.php">Contact Us</a></li>
                    <li><a href="roadmap.php">Roadmap</a></li>
                </ul>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Categories</h3>
                <ul class="footer-links">
                    <li><a href="menu.php?category=fruit-salads">Fruit Salads</a></li>
                    <li><a href="menu.php?category=oats-bowls">Oats Bowls</a></li>
                    <li><a href="menu.php?category=smoothies">Smoothies</a></li>
                    <li><a href="menu.php?category=tea-coffee">Tea & Coffee</a></li>
                </ul>
            </div>
            
            <div class="footer-contact">
                <h3 class="footer-title">Contact Us</h3>
                <?php if (!empty($settings['phone_number'])): ?>
                <p><i class="fas fa-phone"></i> <?php echo htmlspecialchars($settings['phone_number']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['whatsapp_number'])): ?>
                <p><i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($settings['whatsapp_number']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['admin_email'])): ?>
                <p><i class="fas fa-envelope"></i> <?php echo htmlspecialchars($settings['admin_email']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['address'])): ?>
                <p><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($settings['address']); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> FRUITOLA - Daily Fresh Dose. All rights reserved.</p>
        </div>
    </footer>

    <script>
        // Mobile menu toggle
        function toggleMenu() {
            document.getElementById('navLinks').classList.toggle('active');
        }
        
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.boxShadow = '0 5px 30px rgba(0,0,0,0.1)';
            } else {
                navbar.style.boxShadow = '0 2px 30px rgba(0,0,0,0.1)';
            }
        });
        
        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
</body>
</html>
