<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Project Roadmap - FRUITOLA | Daily Fresh Dose</title>
    <meta name="description" content="Explore the FRUITOLA project roadmap - our journey from planning to launch.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <span class="logo-text">FRUITOLA</span>
            </a>
            <ul class="nav-links" id="navLinks">
                <li><a href="index.php">Home</a></li>
                <li><a href="menu.php">Menu</a></li>
                <li><a href="reviews.php">Reviews</a></li>
                <li><a href="contact.php">Contact</a></li>
                <li><a href="roadmap.php" class="active">Roadmap</a></li>
            </ul>
            <div class="mobile-menu-btn" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">Project Roadmap</h1>
            <p class="page-subtitle">Our journey from vision to reality</p>
        </div>
    </section>

    <!-- Roadmap Section -->
    <section class="section" style="background: linear-gradient(135deg, #fff9f5 0%, #f0fff4 100%);">
        <div class="roadmap-container">
            <div class="roadmap-timeline">
                
                <!-- Phase 1 -->
                <div class="roadmap-item">
                    <span class="roadmap-phase">PHASE 1</span>
                    <h3 class="roadmap-title">Planning & Strategy</h3>
                    <ul class="roadmap-list">
                        <li>Brand identity development - FRUITOLA logo and visual design</li>
                        <li>Color theme selection - Fresh Red, Yellow/Orange, Green accents</li>
                        <li>Website structure planning - 5 main pages + Admin panel</li>
                        <li>Database design and schema creation</li>
                        <li>Feature list finalization and prioritization</li>
                        <li>Technology stack selection - Core PHP, MySQL, HTML/CSS/JS</li>
                        <li>Target audience analysis and market research</li>
                        <li>Competitor analysis and differentiation strategy</li>
                    </ul>
                </div>
                
                <!-- Phase 2 -->
                <div class="roadmap-item">
                    <span class="roadmap-phase">PHASE 2</span>
                    <h3 class="roadmap-title">UI/UX Design</h3>
                    <ul class="roadmap-list">
                        <li>Wireframe creation for all pages</li>
                        <li>Responsive design mockups for mobile and desktop</li>
                        <li>3D card design and hover effect planning</li>
                        <li>Glassmorphism card design implementation</li>
                        <li>Animation and transition planning</li>
                        <li>Color palette implementation across all components</li>
                        <li>Typography and icon selection</li>
                        <li>User flow optimization and navigation design</li>
                    </ul>
                </div>
                
                <!-- Phase 3 -->
                <div class="roadmap-item">
                    <span class="roadmap-phase">PHASE 3</span>
                    <h3 class="roadmap-title">Development</h3>
                    <ul class="roadmap-list">
                        <li>Database setup and table creation</li>
                        <li>Core PHP backend development</li>
                        <li>Frontend pages development (Home, Menu, Reviews, Contact, Roadmap)</li>
                        <li>Admin panel development with full CRUD operations</li>
                        <li>Menu management system - Add, Edit, Delete items</li>
                        <li>Review system with admin approval workflow</li>
                        <li>Contact form with email notification</li>
                        <li>WhatsApp integration for orders</li>
                        <li>Image upload and management system</li>
                        <li>Site settings and configuration panel</li>
                    </ul>
                </div>
                
                <!-- Phase 4 -->
                <div class="roadmap-item">
                    <span class="roadmap-phase">PHASE 4</span>
                    <h3 class="roadmap-title">Testing & Quality Assurance</h3>
                    <ul class="roadmap-list">
                        <li>Mobile responsiveness testing across devices</li>
                        <li>Cross-browser compatibility testing</li>
                        <li>Form validation and error handling testing</li>
                        <li>Email system testing and SMTP configuration</li>
                        <li>Security testing - SQL injection, XSS prevention</li>
                        <li>Performance optimization and speed testing</li>
                        <li>User acceptance testing (UAT)</li>
                        <li>Bug fixing and final polish</li>
                    </ul>
                </div>
                
                <!-- Phase 5 -->
                <div class="roadmap-item">
                    <span class="roadmap-phase">PHASE 5</span>
                    <h3 class="roadmap-title">Launch & Deployment</h3>
                    <ul class="roadmap-list">
                        <li>cPanel hosting setup and configuration</li>
                        <li>Domain connection and DNS configuration</li>
                        <li>SSL certificate installation</li>
                        <li>Database migration to production server</li>
                        <li>Final content review and updates</li>
                        <li>SEO optimization and meta tags</li>
                        <li>Google Analytics integration</li>
                        <li>Social media integration</li>
                        <li>Official launch and go-live</li>
                        <li>Post-launch monitoring and support</li>
                    </ul>
                </div>
                
                <!-- Future -->
                <div class="roadmap-item">
                    <span class="roadmap-phase" style="background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);">FUTURE</span>
                    <h3 class="roadmap-title">Upcoming Features</h3>
                    <ul class="roadmap-list">
                        <li>Online payment gateway integration</li>
                        <li>Customer loyalty program</li>
                        <li>Mobile app development (Android & iOS)</li>
                        <li>Delivery tracking system</li>
                        <li>Subscription-based meal plans</li>
                        <li>Multi-language support</li>
                        <li>Franchise management module</li>
                        <li>Advanced analytics dashboard</li>
                    </ul>
                </div>
                
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="section" style="background: white;">
        <div class="section-header">
            <h2 class="section-title">
                Project <span class="highlight">Highlights</span>
            </h2>
        </div>
        
        <div class="stats-grid" style="max-width: 1000px; margin: 0 auto;">
            <div class="stat-card">
                <div class="stat-icon blue">
                    <i class="fas fa-code"></i>
                </div>
                <div class="stat-info">
                    <h3>5+</h3>
                    <p>Frontend Pages</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon green">
                    <i class="fas fa-database"></i>
                </div>
                <div class="stat-info">
                    <h3>6</h3>
                    <p>Database Tables</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon orange">
                    <i class="fas fa-cog"></i>
                </div>
                <div class="stat-info">
                    <h3>10+</h3>
                    <p>Admin Features</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon red">
                    <i class="fas fa-magic"></i>
                </div>
                <div class="stat-info">
                    <h3>15+</h3>
                    <p>Animations & Effects</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tech Stack Section -->
    <section class="section" style="background: linear-gradient(135deg, #fff9f5 0%, #f0fff4 100%);">
        <div class="section-header">
            <h2 class="section-title">
                Technology <span class="highlight">Stack</span>
            </h2>
            <p class="section-subtitle">
                Built with modern, reliable technologies
            </p>
        </div>
        
        <div style="max-width: 1000px; margin: 0 auto; display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 30px;">
            <div class="contact-card" style="text-align: center;">
                <div class="contact-icon">
                    <i class="fab fa-php"></i>
                </div>
                <h3>Core PHP</h3>
                <p>Backend Development</p>
            </div>
            
            <div class="contact-card" style="text-align: center;">
                <div class="contact-icon" style="background: linear-gradient(135deg, #f39c12 0%, #e74c3c 100%);">
                    <i class="fas fa-database"></i>
                </div>
                <h3>MySQL</h3>
                <p>Database Management</p>
            </div>
            
            <div class="contact-card" style="text-align: center;">
                <div class="contact-icon" style="background: linear-gradient(135deg, #e74c3c 0%, #3498db 100%);">
                    <i class="fab fa-html5"></i>
                </div>
                <h3>HTML5 & CSS3</h3>
                <p>Frontend Structure</p>
            </div>
            
            <div class="contact-card" style="text-align: center;">
                <div class="contact-icon" style="background: linear-gradient(135deg, #f1c40f 0%, #f39c12 100%);">
                    <i class="fab fa-js"></i>
                </div>
                <h3>JavaScript</h3>
                <p>Interactive Features</p>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="cta-content">
            <h2 class="cta-title">Be Part of Our Journey</h2>
            <p class="cta-text">Experience the freshness today. Order now and join the FRUITOLA family!</p>
            <div class="cta-buttons">
                <a href="menu.php" class="btn btn-white">
                    <i class="fas fa-utensils"></i> View Menu
                </a>
                <a href="contact.php" class="btn btn-outline-white">
                    <i class="fas fa-envelope"></i> Contact Us
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <div class="footer-brand">
                <h2 class="logo-text">FRUITOLA</h2>
                <p>Your daily fresh dose of nature's goodness. We serve premium fruit bowls, smoothies, and healthy snacks made with 100% real fruits.</p>
                <div class="footer-social">
                    <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Quick Links</h3>
                <ul class="footer-links">
                    <li><a href="index.php">Home</a></li>
                    <li><a href="menu.php">Our Menu</a></li>
                    <li><a href="reviews.php">Reviews</a></li>
                    <li><a href="contact.php">Contact Us</a></li>
                    <li><a href="roadmap.php">Roadmap</a></li>
                </ul>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Categories</h3>
                <ul class="footer-links">
                    <li><a href="menu.php?category=fruit-salads">Fruit Salads</a></li>
                    <li><a href="menu.php?category=oats-bowls">Oats Bowls</a></li>
                    <li><a href="menu.php?category=smoothies">Smoothies</a></li>
                    <li><a href="menu.php?category=tea-coffee">Tea & Coffee</a></li>
                </ul>
            </div>
            
            <div class="footer-contact">
                <h3 class="footer-title">Contact Us</h3>
                <p><i class="fas fa-envelope"></i> info@fruitola.in</p>
                <p><i class="fas fa-globe"></i> www.fruitola.in</p>
            </div>
        </div>
        
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> FRUITOLA - Daily Fresh Dose. All rights reserved.</p>
        </div>
    </footer>

    <script>
        function toggleMenu() {
            document.getElementById('navLinks').classList.toggle('active');
        }
        
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.boxShadow = '0 5px 30px rgba(0,0,0,0.1)';
            } else {
                navbar.style.boxShadow = '0 2px 30px rgba(0,0,0,0.1)';
            }
        });
        
        // Animate roadmap items on scroll
        const observerOptions = {
            threshold: 0.2,
            rootMargin: '0px 0px -50px 0px'
        };
        
        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateX(0)';
                }
            });
        }, observerOptions);
        
        document.querySelectorAll('.roadmap-item').forEach(item => {
            item.style.opacity = '0';
            item.style.transform = 'translateX(-30px)';
            item.style.transition = 'all 0.6s ease';
            observer.observe(item);
        });
    </script>
</body>
</html>
