<?php
require_once '../config/db.php';

// Check if logged in
if (!isAdminLoggedIn()) {
    redirect('login.php');
}

$conn = getDBConnection();

// Get statistics
$stats = [
    'menu_items' => 0,
    'reviews' => 0,
    'messages' => 0,
    'pending_reviews' => 0
];

$result = $conn->query("SELECT COUNT(*) as count FROM menu_items WHERE active = 1");
if ($result) $stats['menu_items'] = $result->fetch_assoc()['count'];

$result = $conn->query("SELECT COUNT(*) as count FROM reviews");
if ($result) $stats['reviews'] = $result->fetch_assoc()['count'];

$result = $conn->query("SELECT COUNT(*) as count FROM contact_messages");
if ($result) $stats['messages'] = $result->fetch_assoc()['count'];

$result = $conn->query("SELECT COUNT(*) as count FROM reviews WHERE status = 'pending'");
if ($result) $stats['pending_reviews'] = $result->fetch_assoc()['count'];

// Get recent reviews
$recent_reviews = [];
$result = $conn->query("SELECT * FROM reviews ORDER BY created_at DESC LIMIT 5");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $recent_reviews[] = $row;
    }
}

// Get recent messages
$recent_messages = [];
$result = $conn->query("SELECT * FROM contact_messages ORDER BY created_at DESC LIMIT 5");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $recent_messages[] = $row;
    }
}

$conn->close();

$flash = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - FRUITOLA Admin</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .admin-body {
            background: #f5f7fa;
            min-height: 100vh;
        }
        
        .admin-wrapper {
            display: flex;
        }
        
        .admin-sidebar {
            width: 280px;
            background: #2c3e50;
            min-height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            padding: 30px 20px;
            overflow-y: auto;
        }
        
        .admin-logo {
            text-align: center;
            margin-bottom: 40px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .admin-logo h2 {
            color: white;
            font-size: 1.8rem;
        }
        
        .admin-logo span {
            color: #f39c12;
        }
        
        .admin-nav {
            list-style: none;
        }
        
        .admin-nav li {
            margin-bottom: 5px;
        }
        
        .admin-nav a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            border-radius: 12px;
            transition: all 0.3s ease;
        }
        
        .admin-nav a:hover,
        .admin-nav a.active {
            background: #e74c3c;
            color: white;
        }
        
        .admin-nav a i {
            width: 20px;
        }
        
        .admin-main {
            margin-left: 280px;
            flex: 1;
            padding: 30px;
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .admin-title {
            font-size: 1.8rem;
            font-weight: 700;
        }
        
        .admin-user {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .admin-user a {
            color: #e74c3c;
            text-decoration: none;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }
        
        .stat-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            display: flex;
            align-items: center;
            gap: 20px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .stat-icon {
            width: 70px;
            height: 70px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
        }
        
        .stat-icon.blue { background: rgba(52, 152, 219, 0.1); color: #3498db; }
        .stat-icon.green { background: rgba(39, 174, 96, 0.1); color: #27ae60; }
        .stat-icon.orange { background: rgba(243, 156, 18, 0.1); color: #f39c12; }
        .stat-icon.red { background: rgba(231, 76, 60, 0.1); color: #e74c3c; }
        
        .stat-info h3 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 5px;
        }
        
        .stat-info p {
            color: #666;
        }
        
        .dashboard-section {
            background: white;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        }
        
        .section-header-flex {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .section-header-flex h3 {
            font-size: 1.3rem;
            font-weight: 700;
        }
        
        .view-all {
            color: #e74c3c;
            text-decoration: none;
            font-weight: 600;
        }
        
        .data-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .data-table th,
        .data-table td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        
        .data-table th {
            font-weight: 700;
            color: #666;
            background: #f8f9fa;
        }
        
        .data-table tr:hover {
            background: #f8f9fa;
        }
        
        .status-badge {
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .status-pending { background: #fff3cd; color: #856404; }
        .status-approved { background: #d4edda; color: #155724; }
        .status-unread { background: #cce5ff; color: #004085; }
        
        .stars {
            color: #f39c12;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 12px;
            margin-bottom: 25px;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        @media (max-width: 768px) {
            .admin-sidebar {
                width: 100%;
                position: relative;
                min-height: auto;
            }
            
            .admin-main {
                margin-left: 0;
            }
            
            .admin-wrapper {
                flex-direction: column;
            }
        }
    </style>
</head>
<body class="admin-body">
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <aside class="admin-sidebar">
            <div class="admin-logo">
                <h2>FRUITOLA <span>Admin</span></h2>
            </div>
            
            <ul class="admin-nav">
                <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
                <li><a href="menu-add.php"><i class="fas fa-plus-circle"></i> Add Menu Item</a></li>
                <li><a href="menu-manage.php"><i class="fas fa-utensils"></i> Manage Menu</a></li>
                <li><a href="reviews-manage.php"><i class="fas fa-star"></i> Reviews <?php if($stats['pending_reviews'] > 0): ?><span style="background: #e74c3c; color: white; padding: 2px 8px; border-radius: 10px; font-size: 0.75rem; margin-left: 5px;"><?php echo $stats['pending_reviews']; ?></span><?php endif; ?></a></li>
                <li><a href="messages.php"><i class="fas fa-envelope"></i> Messages</a></li>
                <li><a href="email-settings.php"><i class="fas fa-cog"></i> Settings</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </aside>
        
        <!-- Main Content -->
        <main class="admin-main">
            <div class="admin-header">
                <h1 class="admin-title">Dashboard</h1>
                <div class="admin-user">
                    <span><i class="fas fa-user"></i> <?php echo htmlspecialchars($_SESSION['admin_email'] ?? 'Admin'); ?></span>
                    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
            </div>
            
            <?php if ($flash): ?>
                <div class="alert alert-<?php echo $flash['type']; ?>">
                    <i class="fas fa-<?php echo $flash['type'] == 'success' ? 'check-circle' : 'exclamation-circle'; ?>"></i> <?php echo $flash['message']; ?>
                </div>
            <?php endif; ?>
            
            <!-- Stats Grid -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon blue">
                        <i class="fas fa-utensils"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $stats['menu_items']; ?></h3>
                        <p>Menu Items</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon green">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $stats['reviews']; ?></h3>
                        <p>Total Reviews</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon orange">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $stats['messages']; ?></h3>
                        <p>Messages</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon red">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $stats['pending_reviews']; ?></h3>
                        <p>Pending Reviews</p>
                    </div>
                </div>
            </div>
            
            <!-- Recent Reviews -->
            <div class="dashboard-section">
                <div class="section-header-flex">
                    <h3><i class="fas fa-star" style="color: #f39c12;"></i> Recent Reviews</h3>
                    <a href="reviews-manage.php" class="view-all">View All <i class="fas fa-arrow-right"></i></a>
                </div>
                
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th>Rating</th>
                            <th>Review</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($recent_reviews)): ?>
                            <?php foreach ($recent_reviews as $review): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($review['customer_name']); ?></td>
                                <td class="stars">
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                        <i class="fas fa-star<?php echo $i <= $review['rating'] ? '' : '-o'; ?>"></i>
                                    <?php endfor; ?>
                                </td>
                                <td><?php echo htmlspecialchars(substr($review['review_text'], 0, 50)) . '...'; ?></td>
                                <td><span class="status-badge status-<?php echo $review['status']; ?>"><?php echo ucfirst($review['status']); ?></span></td>
                                <td><?php echo date('M d, Y', strtotime($review['created_at'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" style="text-align: center; color: #666;">No reviews yet</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Recent Messages -->
            <div class="dashboard-section">
                <div class="section-header-flex">
                    <h3><i class="fas fa-envelope" style="color: #3498db;"></i> Recent Messages</h3>
                    <a href="messages.php" class="view-all">View All <i class="fas fa-arrow-right"></i></a>
                </div>
                
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Subject</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($recent_messages)): ?>
                            <?php foreach ($recent_messages as $msg): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($msg['name']); ?></td>
                                <td><?php echo htmlspecialchars($msg['email']); ?></td>
                                <td><?php echo htmlspecialchars($msg['subject'] ?: 'No Subject'); ?></td>
                                <td><span class="status-badge status-<?php echo $msg['status']; ?>"><?php echo ucfirst($msg['status']); ?></span></td>
                                <td><?php echo date('M d, Y', strtotime($msg['created_at'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" style="text-align: center; color: #666;">No messages yet</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>
