<?php
require_once 'config/db.php';

$conn = getDBConnection();

// Get all categories
$categories = [];
$result = $conn->query("SELECT * FROM categories ORDER BY display_order");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
}

// Get selected category
$selected_category = $_GET['category'] ?? '';

// Get menu items
$menu_items = [];
if ($selected_category) {
    $stmt = $conn->prepare("SELECT m.*, c.name as category_name FROM menu_items m JOIN categories c ON m.category_id = c.id WHERE c.slug = ? AND m.active = 1 ORDER BY m.created_at DESC");
    $stmt->bind_param("s", $selected_category);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $conn->query("SELECT m.*, c.name as category_name FROM menu_items m JOIN categories c ON m.category_id = c.id WHERE m.active = 1 ORDER BY m.created_at DESC");
}

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $menu_items[] = $row;
    }
}

// Get site settings
$settings = [];
$result = $conn->query("SELECT * FROM site_settings");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

$conn->close();

$whatsapp_number = $settings['whatsapp_number'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Menu - FRUITOLA | Daily Fresh Dose</title>
    <meta name="description" content="Explore our delicious menu of fruit bowls, smoothies, oats bowls, and healthy snacks. Made with 100% real fruits.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <span class="logo-text">FRUITOLA</span>
            </a>
            <ul class="nav-links" id="navLinks">
                <li><a href="index.php">Home</a></li>
                <li><a href="menu.php" class="active">Menu</a></li>
                <li><a href="reviews.php">Reviews</a></li>
                <li><a href="contact.php">Contact</a></li>
                <li><a href="roadmap.php">Roadmap</a></li>
            </ul>
            <div class="mobile-menu-btn" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">Our Menu</h1>
            <p class="page-subtitle">Fresh, healthy, and delicious - made with love</p>
        </div>
    </section>

    <!-- Menu Section -->
    <section class="section" style="background: white;">
        <!-- Category Filter -->
        <div class="menu-categories">
            <a href="menu.php" class="category-btn <?php echo empty($selected_category) ? 'active' : ''; ?>">
                All Items
            </a>
            <?php foreach ($categories as $category): ?>
            <a href="menu.php?category=<?php echo $category['slug']; ?>" class="category-btn <?php echo $selected_category == $category['slug'] ? 'active' : ''; ?>">
                <?php echo htmlspecialchars($category['name']); ?>
            </a>
            <?php endforeach; ?>
        </div>
        
        <!-- Menu Grid -->
        <div class="menu-grid">
            <?php if (!empty($menu_items)): ?>
                <?php foreach ($menu_items as $item): ?>
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="<?php echo $item['image'] ? 'assets/uploads/' . $item['image'] : 'https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400'; ?>" alt="<?php echo htmlspecialchars($item['name']); ?>">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category"><?php echo htmlspecialchars($item['category_name']); ?></span>
                        <h3 class="menu-card-title"><?php echo htmlspecialchars($item['name']); ?></h3>
                        <p class="menu-card-description"><?php echo htmlspecialchars($item['description']); ?></p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹<?php echo number_format($item['price'], 2); ?></span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order <?php echo urlencode($item['name']); ?>" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- Default menu items -->
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400" alt="Tropical Paradise Bowl">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Fruit Salads</span>
                        <h3 class="menu-card-title">Tropical Paradise Bowl</h3>
                        <p class="menu-card-description">Fresh mango, pineapple, kiwi, strawberries, and blueberries with honey drizzle and granola topping</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹149.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Tropical Paradise Bowl" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1490474418585-ba9bad8fd0ea?w=400" alt="Mixed Fruit Bowl">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Fruit Salads</span>
                        <h3 class="menu-card-title">Mixed Fruit Delight</h3>
                        <p class="menu-card-description">Seasonal fresh fruits including apple, banana, grapes, orange, and pomegranate with mint dressing</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹129.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Mixed Fruit Delight" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1553530979-7ee52a2670c4?w=400" alt="Berry Blast Smoothie">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Smoothies</span>
                        <h3 class="menu-card-title">Berry Blast Smoothie</h3>
                        <p class="menu-card-description">Strawberries, blueberries, raspberries blended with yogurt and a hint of honey</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹129.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Berry Blast Smoothie" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1543573852-1a71a6ce19bc?w=400" alt="Green Detox Smoothie">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Smoothies</span>
                        <h3 class="menu-card-title">Green Detox Smoothie</h3>
                        <p class="menu-card-description">Spinach, kale, green apple, cucumber, and ginger for a healthy morning boost</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹139.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Green Detox Smoothie" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1511690656952-34342bb7c2f2?w=400" alt="Overnight Oats">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Oats Bowls</span>
                        <h3 class="menu-card-title">Overnight Oats Delight</h3>
                        <p class="menu-card-description">Rolled oats soaked in almond milk topped with fresh fruits, nuts, and seeds</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹179.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Overnight Oats Delight" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1588137372308-15f75323ca8d?w=400" alt="Chocolate Oats">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Oats Bowls</span>
                        <h3 class="menu-card-title">Chocolate Oats Bowl</h3>
                        <p class="menu-card-description">Oats with cocoa powder, banana slices, chocolate chips, and a drizzle of nutella</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹189.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Chocolate Oats Bowl" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1544787219-7f47ccb76574?w=400" alt="Masala Chai">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Tea & Coffee</span>
                        <h3 class="menu-card-title">Masala Chai</h3>
                        <p class="menu-card-description">Traditional Indian spiced tea with cardamom, ginger, and cinnamon</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹49.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Masala Chai" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1497515114889-1c6a5e7cda6d?w=400" alt="Cold Coffee">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Tea & Coffee</span>
                        <h3 class="menu-card-title">Cold Coffee</h3>
                        <p class="menu-card-description">Rich and creamy cold coffee topped with whipped cream and chocolate syrup</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹99.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Cold Coffee" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1553909489-cd47e3b4430f?w=400" alt="Veg Sandwich">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Sandwich & Burger</span>
                        <h3 class="menu-card-title">Veg Grilled Sandwich</h3>
                        <p class="menu-card-description">Fresh vegetables, cheese, and herbs grilled to perfection in multigrain bread</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹119.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Veg Grilled Sandwich" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1568901346375-23c9450c58cd?w=400" alt="Veg Burger">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Sandwich & Burger</span>
                        <h3 class="menu-card-title">Classic Veg Burger</h3>
                        <p class="menu-card-description">Crispy vegetable patty with fresh lettuce, tomato, and special sauce</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹139.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Classic Veg Burger" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1549007994-cb92caebd54b?w=400" alt="Chocolate Brownie">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Chocolates</span>
                        <h3 class="menu-card-title">Chocolate Brownie</h3>
                        <p class="menu-card-description">Rich, fudgy chocolate brownie served with vanilla ice cream</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹149.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Chocolate Brownie" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="menu-card">
                    <div class="menu-card-image">
                        <img src="https://images.unsplash.com/photo-1481391319762-47dff72954d9?w=400" alt="Chocolate Truffles">
                    </div>
                    <div class="menu-card-content">
                        <span class="menu-card-category">Chocolates</span>
                        <h3 class="menu-card-title">Chocolate Truffles</h3>
                        <p class="menu-card-description">Handmade chocolate truffles in assorted flavors - pack of 6</p>
                        <div class="menu-card-footer">
                            <span class="menu-card-price">₹199.00</span>
                            <?php if ($whatsapp_number): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to order Chocolate Truffles" class="btn btn-primary btn-small" target="_blank">
                                <i class="fab fa-whatsapp"></i> Order
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="cta-content">
            <h2 class="cta-title">Can't Decide What to Order?</h2>
            <p class="cta-text">Chat with us on WhatsApp and we'll help you choose the perfect item!</p>
            <div class="cta-buttons">
                <?php if ($whatsapp_number): ?>
                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>" class="btn btn-white" target="_blank">
                    <i class="fab fa-whatsapp"></i> Chat Now
                </a>
                <?php endif; ?>
                <a href="contact.php" class="btn btn-outline-white">
                    <i class="fas fa-phone"></i> Call Us
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <div class="footer-brand">
                <h2 class="logo-text">FRUITOLA</h2>
                <p>Your daily fresh dose of nature's goodness. We serve premium fruit bowls, smoothies, and healthy snacks made with 100% real fruits.</p>
                <div class="footer-social">
                    <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Quick Links</h3>
                <ul class="footer-links">
                    <li><a href="index.php">Home</a></li>
                    <li><a href="menu.php">Our Menu</a></li>
                    <li><a href="reviews.php">Reviews</a></li>
                    <li><a href="contact.php">Contact Us</a></li>
                    <li><a href="roadmap.php">Roadmap</a></li>
                </ul>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Categories</h3>
                <ul class="footer-links">
                    <li><a href="menu.php?category=fruit-salads">Fruit Salads</a></li>
                    <li><a href="menu.php?category=oats-bowls">Oats Bowls</a></li>
                    <li><a href="menu.php?category=smoothies">Smoothies</a></li>
                    <li><a href="menu.php?category=tea-coffee">Tea & Coffee</a></li>
                </ul>
            </div>
            
            <div class="footer-contact">
                <h3 class="footer-title">Contact Us</h3>
                <?php if (!empty($settings['phone_number'])): ?>
                <p><i class="fas fa-phone"></i> <?php echo htmlspecialchars($settings['phone_number']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['whatsapp_number'])): ?>
                <p><i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($settings['whatsapp_number']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['admin_email'])): ?>
                <p><i class="fas fa-envelope"></i> <?php echo htmlspecialchars($settings['admin_email']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['address'])): ?>
                <p><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($settings['address']); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> FRUITOLA - Daily Fresh Dose. All rights reserved.</p>
        </div>
    </footer>

    <script>
        function toggleMenu() {
            document.getElementById('navLinks').classList.toggle('active');
        }
        
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.boxShadow = '0 5px 30px rgba(0,0,0,0.1)';
            } else {
                navbar.style.boxShadow = '0 2px 30px rgba(0,0,0,0.1)';
            }
        });
    </script>
</body>
</html>
