<?php
// FRUITOLA Installation Script
// This script runs only once to set up the database and admin user

if (file_exists('../config/installed.php')) {
    die("Installation already completed. Please delete the install folder for security.");
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_user = $_POST['db_user'] ?? '';
    $db_pass = $_POST['db_pass'] ?? '';
    $db_name = $_POST['db_name'] ?? '';
    $admin_email = $_POST['admin_email'] ?? '';
    $admin_password = $_POST['admin_password'] ?? '';
    
    // Validate inputs
    if (empty($db_user) || empty($db_name) || empty($admin_email) || empty($admin_password)) {
        $error = "Please fill in all required fields.";
    } else {
        // Test connection
        $conn = new mysqli($db_host, $db_user, $db_pass);
        
        if ($conn->connect_error) {
            $error = "Database connection failed: " . $conn->connect_error;
        } else {
            // Create database
            $conn->query("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $conn->select_db($db_name);
            
            // Create tables
            $tables_sql = [
                "CREATE TABLE IF NOT EXISTS admin (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    email VARCHAR(255) NOT NULL UNIQUE,
                    password VARCHAR(255) NOT NULL,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                )",
                
                "CREATE TABLE IF NOT EXISTS categories (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    name VARCHAR(100) NOT NULL,
                    slug VARCHAR(100) NOT NULL UNIQUE,
                    icon VARCHAR(50),
                    display_order INT DEFAULT 0,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                )",
                
                "CREATE TABLE IF NOT EXISTS menu_items (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    category_id INT NOT NULL,
                    name VARCHAR(200) NOT NULL,
                    description TEXT,
                    price DECIMAL(10,2) NOT NULL,
                    image VARCHAR(255),
                    featured TINYINT DEFAULT 0,
                    active TINYINT DEFAULT 1,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
                )",
                
                "CREATE TABLE IF NOT EXISTS reviews (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    customer_name VARCHAR(100) NOT NULL,
                    customer_email VARCHAR(255),
                    rating INT NOT NULL CHECK (rating >= 1 AND rating <= 5),
                    review_text TEXT NOT NULL,
                    image VARCHAR(255),
                    status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                )",
                
                "CREATE TABLE IF NOT EXISTS contact_messages (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    name VARCHAR(100) NOT NULL,
                    email VARCHAR(255) NOT NULL,
                    phone VARCHAR(20),
                    subject VARCHAR(200),
                    message TEXT NOT NULL,
                    status ENUM('unread', 'read', 'replied') DEFAULT 'unread',
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                )",
                
                "CREATE TABLE IF NOT EXISTS site_settings (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    setting_key VARCHAR(100) NOT NULL UNIQUE,
                    setting_value TEXT,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                )"
            ];
            
            foreach ($tables_sql as $sql) {
                if (!$conn->query($sql)) {
                    $error = "Error creating tables: " . $conn->error;
                    break;
                }
            }
            
            if (empty($error)) {
                // Insert default categories
                $categories = [
                    ['Fruit Salads', 'fruit-salads', 'salad', 1],
                    ['Oats Bowls', 'oats-bowls', 'bowl', 2],
                    ['Smoothies', 'smoothies', 'drink', 3],
                    ['Chocolates', 'chocolates', 'candy', 4],
                    ['Tea & Coffee', 'tea-coffee', 'coffee', 5],
                    ['Sandwich & Burger', 'sandwich-burger', 'burger', 6]
                ];
                
                $stmt = $conn->prepare("INSERT INTO categories (name, slug, icon, display_order) VALUES (?, ?, ?, ?)");
                foreach ($categories as $cat) {
                    $stmt->bind_param("sssi", $cat[0], $cat[1], $cat[2], $cat[3]);
                    $stmt->execute();
                }
                
                // Insert default admin
                $hashed_password = password_hash($admin_password, PASSWORD_DEFAULT);
                $stmt = $conn->prepare("INSERT INTO admin (email, password) VALUES (?, ?)");
                $stmt->bind_param("ss", $admin_email, $hashed_password);
                $stmt->execute();
                
                // Insert default site settings
                $settings = [
                    ['site_name', 'FRUITOLA'],
                    ['site_tagline', 'Daily Fresh Dose'],
                    ['admin_email', $admin_email],
                    ['smtp_host', ''],
                    ['smtp_port', '587'],
                    ['smtp_user', ''],
                    ['smtp_pass', ''],
                    ['whatsapp_number', ''],
                    ['phone_number', ''],
                    ['address', ''],
                    ['google_map', '']
                ];
                
                $stmt = $conn->prepare("INSERT INTO site_settings (setting_key, setting_value) VALUES (?, ?)");
                foreach ($settings as $setting) {
                    $stmt->bind_param("ss", $setting[0], $setting[1]);
                    $stmt->execute();
                }
                
                // Create installed flag file
                file_put_contents('../config/installed.php', '<?php // Installation completed on ' . date('Y-m-d H:i:s') . ' ?>');
                
                // Update db.php with new credentials
                $db_config = "<?php
// Database Configuration File
// FRUITOLA - Daily Fresh Dose

session_start();

// Database credentials
define('DB_HOST', '$db_host');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');
define('DB_NAME', '$db_name');

// Create database connection
function getDBConnection() {
    \$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if (\$conn->connect_error) {
        die(\"Connection failed: \" . \$conn->connect_error);
    }
    
    \$conn->set_charset(\"utf8mb4\");
    return \$conn;
}

// Helper function to sanitize input
function sanitize(\$conn, \$data) {
    \$data = trim(\$data);
    \$data = stripslashes(\$data);
    \$data = htmlspecialchars(\$data, ENT_QUOTES, 'UTF-8');
    return \$conn->real_escape_string(\$data);
}

// Check if user is logged in (for admin)
function isAdminLoggedIn() {
    return isset(\$_SESSION['admin_id']) && !empty(\$_SESSION['admin_id']);
}

// Redirect function
function redirect(\$url) {
    header(\"Location: \" . \$url);
    exit();
}

// Flash message function
function setFlashMessage(\$type, \$message) {
    \$_SESSION['flash_message'] = [
        'type' => \$type,
        'message' => \$message
    ];
}

function getFlashMessage() {
    if (isset(\$_SESSION['flash_message'])) {
        \$msg = \$_SESSION['flash_message'];
        unset(\$_SESSION['flash_message']);
        return \$msg;
    }
    return null;
}
?>";
                
                file_put_contents('../config/db.php', $db_config);
                
                $success = "Installation completed successfully! Please delete the install folder for security.";
            }
            
            $conn->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FRUITOLA - Installation</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #ff6b6b 0%, #ffd93d 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .install-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo h1 {
            color: #e74c3c;
            font-size: 2.5rem;
            font-weight: 800;
            letter-spacing: 2px;
        }
        
        .logo p {
            color: #f39c12;
            font-size: 1rem;
            margin-top: 5px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #e74c3c;
        }
        
        .btn-install {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #e74c3c 0%, #f39c12 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn-install:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(231, 76, 60, 0.3);
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }
        
        .alert-success {
            background: #efe;
            color: #3c3;
            border: 1px solid #cfc;
        }
        
        .section-title {
            color: #333;
            font-size: 1.1rem;
            margin: 25px 0 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="logo">
            <h1>FRUITOLA</h1>
            <p>Daily Fresh Dose - Installation</p>
        </div>
        
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
            <p style="text-align: center; margin-top: 20px;">
                <a href="../admin/login.php" style="color: #e74c3c; text-decoration: none; font-weight: 600;">Go to Admin Login</a>
            </p>
        <?php else: ?>
            <form method="POST" action="">
                <div class="section-title">Database Settings</div>
                
                <div class="form-group">
                    <label>Database Host</label>
                    <input type="text" name="db_host" value="localhost" required>
                </div>
                
                <div class="form-group">
                    <label>Database Username *</label>
                    <input type="text" name="db_user" required>
                </div>
                
                <div class="form-group">
                    <label>Database Password</label>
                    <input type="password" name="db_pass">
                </div>
                
                <div class="form-group">
                    <label>Database Name *</label>
                    <input type="text" name="db_name" required>
                </div>
                
                <div class="section-title">Admin Account</div>
                
                <div class="form-group">
                    <label>Admin Email *</label>
                    <input type="email" name="admin_email" required>
                </div>
                
                <div class="form-group">
                    <label>Admin Password *</label>
                    <input type="password" name="admin_password" required minlength="6">
                </div>
                
                <button type="submit" class="btn-install">Install FRUITOLA</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
