<?php
require_once 'config/db.php';

$conn = getDBConnection();
$success = '';
$error = '';

// Handle contact form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = sanitize($conn, $_POST['name'] ?? '');
    $email = sanitize($conn, $_POST['email'] ?? '');
    $phone = sanitize($conn, $_POST['phone'] ?? '');
    $subject = sanitize($conn, $_POST['subject'] ?? '');
    $message = sanitize($conn, $_POST['message'] ?? '');
    
    if (empty($name) || empty($email) || empty($message)) {
        $error = "Please fill in all required fields.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "Please enter a valid email address.";
    } else {
        $stmt = $conn->prepare("INSERT INTO contact_messages (name, email, phone, subject, message) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $name, $email, $phone, $subject, $message);
        
        if ($stmt->execute()) {
            // Send email to admin
            $admin_email = '';
            $result = $conn->query("SELECT setting_value FROM site_settings WHERE setting_key = 'admin_email'");
            if ($result && $row = $result->fetch_assoc()) {
                $admin_email = $row['setting_value'];
            }
            
            if ($admin_email) {
                $to = $admin_email;
                $email_subject = "New Contact Form Submission: " . $subject;
                $email_body = "Name: $name\n";
                $email_body .= "Email: $email\n";
                $email_body .= "Phone: $phone\n";
                $email_body .= "Subject: $subject\n\n";
                $email_body .= "Message:\n$message";
                $headers = "From: $email\r\n";
                $headers .= "Reply-To: $email\r\n";
                
                @mail($to, $email_subject, $email_body, $headers);
            }
            
            $success = "Thank you for contacting us! We'll get back to you soon.";
        } else {
            $error = "Something went wrong. Please try again.";
        }
    }
}

// Get site settings
$settings = [];
$result = $conn->query("SELECT * FROM site_settings");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

$conn->close();

$whatsapp_number = $settings['whatsapp_number'] ?? '';
$phone_number = $settings['phone_number'] ?? '';
$admin_email = $settings['admin_email'] ?? '';
$address = $settings['address'] ?? '';
$google_map = $settings['google_map'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - FRUITOLA | Daily Fresh Dose</title>
    <meta name="description" content="Get in touch with FRUITOLA. Contact us for orders, inquiries, or feedback.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <span class="logo-text">FRUITOLA</span>
            </a>
            <ul class="nav-links" id="navLinks">
                <li><a href="index.php">Home</a></li>
                <li><a href="menu.php">Menu</a></li>
                <li><a href="reviews.php">Reviews</a></li>
                <li><a href="contact.php" class="active">Contact</a></li>
                <li><a href="roadmap.php">Roadmap</a></li>
            </ul>
            <div class="mobile-menu-btn" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">Contact Us</h1>
            <p class="page-subtitle">We'd love to hear from you</p>
        </div>
    </section>

    <!-- Contact Info Cards -->
    <section class="section" style="background: white; padding-bottom: 50px;">
        <div class="contact-info">
            <?php if ($phone_number): ?>
            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fas fa-phone"></i>
                </div>
                <h3>Call Us</h3>
                <p><a href="tel:<?php echo preg_replace('/[^0-9]/', '', $phone_number); ?>"><?php echo htmlspecialchars($phone_number); ?></a></p>
            </div>
            <?php endif; ?>
            
            <?php if ($whatsapp_number): ?>
            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fab fa-whatsapp"></i>
                </div>
                <h3>WhatsApp</h3>
                <p><a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>" target="_blank"><?php echo htmlspecialchars($whatsapp_number); ?></a></p>
            </div>
            <?php endif; ?>
            
            <?php if ($admin_email): ?>
            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <h3>Email Us</h3>
                <p><a href="mailto:<?php echo htmlspecialchars($admin_email); ?>"><?php echo htmlspecialchars($admin_email); ?></a></p>
            </div>
            <?php endif; ?>
            
            <?php if ($address): ?>
            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
                <h3>Visit Us</h3>
                <p><?php echo htmlspecialchars($address); ?></p>
            </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Contact Form & Map Section -->
    <section class="section" style="background: linear-gradient(135deg, #fff9f5 0%, #f0fff4 100%);">
        <div class="contact-container">
            <div class="review-form-container" style="margin: 0;">
                <h3 style="margin-bottom: 25px; font-size: 1.5rem;">
                    <i class="fas fa-paper-plane" style="color: var(--primary);"></i> Send us a Message
                </h3>
                
                <?php if ($success): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> <?php echo $success; ?>
                    </div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <div class="form-group">
                        <label>Your Name *</label>
                        <input type="text" name="name" required placeholder="Enter your full name">
                    </div>
                    
                    <div class="form-group">
                        <label>Your Email *</label>
                        <input type="email" name="email" required placeholder="Enter your email address">
                    </div>
                    
                    <div class="form-group">
                        <label>Phone Number</label>
                        <input type="tel" name="phone" placeholder="Enter your phone number">
                    </div>
                    
                    <div class="form-group">
                        <label>Subject</label>
                        <input type="text" name="subject" placeholder="What is this about?">
                    </div>
                    
                    <div class="form-group">
                        <label>Your Message *</label>
                        <textarea name="message" rows="5" required placeholder="Type your message here..."></textarea>
                    </div>
                    
                    <button type="submit" class="btn btn-primary" style="width: 100%;">
                        <i class="fas fa-paper-plane"></i> Send Message
                    </button>
                </form>
            </div>
            
            <div class="map-container">
                <?php if ($google_map): ?>
                    <?php echo $google_map; ?>
                <?php else: ?>
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3502.1234567890123!2d77.209021!3d28.613939!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMjjCsDM2JzUwLjIiTiA3N8KwMTInMzIuNSJF!5e0!3m2!1sen!2sin!4v1234567890123!5m2!1sen!2sin" 
                        allowfullscreen="" 
                        loading="lazy" 
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Quick Order Section -->
    <section class="cta-section">
        <div class="cta-content">
            <h2 class="cta-title">Ready to Place an Order?</h2>
            <p class="cta-text">Order directly on WhatsApp for quick and easy delivery</p>
            <div class="cta-buttons">
                <?php if ($whatsapp_number): ?>
                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>?text=Hi, I want to place an order" class="btn btn-white" target="_blank">
                    <i class="fab fa-whatsapp"></i> Order on WhatsApp
                </a>
                <?php endif; ?>
                <a href="menu.php" class="btn btn-outline-white">
                    <i class="fas fa-utensils"></i> Browse Menu
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <div class="footer-brand">
                <h2 class="logo-text">FRUITOLA</h2>
                <p>Your daily fresh dose of nature's goodness. We serve premium fruit bowls, smoothies, and healthy snacks made with 100% real fruits.</p>
                <div class="footer-social">
                    <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Quick Links</h3>
                <ul class="footer-links">
                    <li><a href="index.php">Home</a></li>
                    <li><a href="menu.php">Our Menu</a></li>
                    <li><a href="reviews.php">Reviews</a></li>
                    <li><a href="contact.php">Contact Us</a></li>
                    <li><a href="roadmap.php">Roadmap</a></li>
                </ul>
            </div>
            
            <div class="footer-links-section">
                <h3 class="footer-title">Categories</h3>
                <ul class="footer-links">
                    <li><a href="menu.php?category=fruit-salads">Fruit Salads</a></li>
                    <li><a href="menu.php?category=oats-bowls">Oats Bowls</a></li>
                    <li><a href="menu.php?category=smoothies">Smoothies</a></li>
                    <li><a href="menu.php?category=tea-coffee">Tea & Coffee</a></li>
                </ul>
            </div>
            
            <div class="footer-contact">
                <h3 class="footer-title">Contact Us</h3>
                <?php if ($phone_number): ?>
                <p><i class="fas fa-phone"></i> <?php echo htmlspecialchars($phone_number); ?></p>
                <?php endif; ?>
                <?php if ($whatsapp_number): ?>
                <p><i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($whatsapp_number); ?></p>
                <?php endif; ?>
                <?php if ($admin_email): ?>
                <p><i class="fas fa-envelope"></i> <?php echo htmlspecialchars($admin_email); ?></p>
                <?php endif; ?>
                <?php if ($address): ?>
                <p><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($address); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> FRUITOLA - Daily Fresh Dose. All rights reserved.</p>
        </div>
    </footer>

    <script>
        function toggleMenu() {
            document.getElementById('navLinks').classList.toggle('active');
        }
        
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.boxShadow = '0 5px 30px rgba(0,0,0,0.1)';
            } else {
                navbar.style.boxShadow = '0 2px 30px rgba(0,0,0,0.1)';
            }
        });
    </script>
</body>
</html>
